; SLA Lead Acid and Lithium Charger Adaptor  

	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

EEPROM0		equ	H'00'	; non-volatile storage for SLA cutoff voltage ms
EEPROM1		equ	H'01'	; non-volatile storage for SLA cutoff voltage ls
EEPROM2		equ	H'02'	; non-volatile storage for SLA float voltage ms
EEPROM3		equ	H'03'	; non-volatile storage for SLA float voltage ls
EEPROM4		equ	H'04'	; non-volatile storage for SLA Compensation mV/deg C

EEPROM5		equ	H'05'	; non-volatile storage for Lead Acid cutoff voltage ms
EEPROM6		equ	H'06'	; non-volatile storage for L/A cutoff voltage ls
EEPROM7		equ	H'07'	; non-volatile storage for L/A float voltage ms
EEPROM8		equ	H'08'	; non-volatile storage for L/A float voltage ls
EEPROM9		equ	H'09'	; non-volatile storage for L/A Compensation mV/deg C

EEPROMA		equ	H'0A'	; non-volatile storage for LiFePO4 cutoff voltage ms
EEPROMB		equ	H'0B'	; non-volatile storage for LiFePO4 cutoff voltage ls
EEPROMC		equ	H'0C'	; non-volatile storage for LiFePO4 no float voltage ms
EEPROMD		equ	H'0D'	; non-volatile storage for LiFePO4 no float voltage ls
EEPROME		equ	H'0E'	; non-volatile storage for LiFePO4 no copmpensation


EEPROM10		equ	H'0F'	; non-volatile storage for charge show at Charge LED option


; Bank 0 RAM

STO_NTC			equ	H'20'	; thermistor stored value
DIGITAL				equ	H'21'	; working register for A/D
CHARGE_RATE		equ	H'22'	; charging rate 0-100%	
CUT_M				equ	H'23'	; cutout voltage high byte
CUT_L	  			equ	H'24'	; cutout voltage low byte
FLOAT_H			equ	H'25'	; float voltage high byte
FLOAT_L			equ	H'26'	; float voltage low byte
COMP				equ	H'27'	; compensation 
BATT_HI				equ	H'28'	; battery volts high byte
BATT_LO			equ	H'29'	; battery low byte
TIMEOUT			equ	H'2A'	; timeout value	
DELCNT			equ	H'2B'	; delay counter
END_FLG			equ	H'2C'	; flag to indicate when to run A/D conversion 	
FLASHER			equ	H'2D'	; LED flasher timer 
LOOP_COUNT		equ	H'2E'	; update A/D counter
TEMPERATURE		equ	H'2F'	; temperature reading deg C	
THERMISTOR		equ	H'30'	; thermistor flag for LED
CHARGE_FLAG		equ	H'31'	; charge flag
CHARGE_PULSE	equ	H'32'	; charge pulse counter
CHARGE_STATE	equ	H'33'	; charge status
CUT_COMP_M		equ	H'34'	; cutout temp compensated voltage high byte
CUT_COMP_L 		equ	H'35'	; cutout temp compensated voltage low byte
FLOAT_COMP_M	equ	H'36'	; float temp compensated voltage high byte
FLOAT_COMP_L		equ	H'37'	; float temp compensated voltage low byte
NEGATIVE			equ	H'38'	; subtract negative flag
CHARGE_CONT		equ	H'39'	; charge controller value transferred at end of each cycle to/1
SECONDS			equ	H'3A'	; seconds counter	
MINUTES			equ	H'3B'	; minutes counter
HOUR				equ H'3C'	; hour counter
VALUE_1			equ	H'3D'	; delay counter
VALUE_2			equ	H'3E'	; delay counter
STORE				equ	H'3F'	; storage of PWM drive value
AD_COUNT			equ	H'40'	; A/D conversion counter
BATT_P8H			equ	H'41'	; battery voltage high byte with 8 added (0.25V)
BATT_P8L			equ	H'42'	; battery voltage low byte 
BATT_M8H			equ	H'43'	; battery voltage high byte with 8 subtracted (0.25V)
BATT_M8L			equ	H'44'	; battery voltage low byte 
ONCE				equ	H'45'	; cycled once flag
CHRG_SHOW		equ	H'46'	; status for charge showing on Charge LED (during absorption and float)
CHARGE_CONT1	equ	H'47'	; charge controller value as used in interrupt
CHARGE_RATE1	equ	H'48'	; charging rate 0-100% comparison value
CHARGE_RATE2	equ	H'49'	; charging rate 0-100% comparison value
HOUR2				equ	H'4A'	; battery discharge timer
COMPARE			equ	H'4B'	; charge comparison value during absorption
LITHIUM				equ	H'4C'	; end of charge flag for Lithium
HOUR3				equ	H'4D'	; timeout value for battery connected and charger off

; math routines
TEMP1				equ	H'5C'
TEMPB0			equ	H'5D'
TEMPB1			equ	H'5E'
TEMPB2			equ	H'5F'
TEMP				equ H'60'
REMB3				equ H'61'
REMB2				equ	H'62'
REMB1      			equ H'63'
REMB0				equ	H'64'
AARGB5			equ	H'65'
AARGB4      			equ H'66'
AARGB3			equ	H'67'
AARGB2      			equ H'68'
AARGB1      			equ H'69'
AARGB0      			equ H'6A'	; most significant byte of argument A
BARGB3      			equ H'6B'
BARGB2      			equ H'6C'
BARGB1      			equ H'6D'
BARGB0      			equ H'6E'	; most significant byte of argument B
LOOPCOUNT   		equ H'6F'  	; division counter
			 
; All Banks RAM
; Interrupt store registers 
W_TMP				equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt

; preprogram EEPROM DATA 
; initial values
; cutoff and float is calculated Vcutout or Vfloat/30.5 x 1023 (converted to Hex for 2-byte value). Each A/D value represents 29.8mV of battery Voltage
; compensation calculated as Comp/50 x 255 	
	org     H'2100'
	DE		H'01', H'D9', H'01', H'C5', D'128'; cutoff 14.1, float 13.5 and compensation -25mV SLA
	DE		H'01', H'E3', H'01', H'CF', D'102'; cutoff 14.4, float 13.8 and compensation -20mV Lead Acid
	DE		H'01', H'D1', H'00', H'00', D'0'	 ; cutoff 13.88V,  no float no compensation LiFePO4
 	DE		H'01' 						  ; charge show is on, clear bit 0 for off

	
; start at memory 0
	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; locate lookup table at start to avoid a 256 bit boundary

TEMP_CONV ; convert A/D values to deg C based on thermistor R=Ae**(B/T) where (T is in K ie deg C plus 273)
; A =0.01058 and B is 4100
	addwf	PCL,f	; add value to program counter
; 60 deg C max
	retlw	D'60'	; 60deg C for A/D D49 (8-bit)
	retlw	D'59'	; deg C for A/D D50(8-bit)
	retlw	D'58'	; deg C for A/D D51(8-bit)
	retlw	D'58'	; deg C for A/D D52(8-bit)
	retlw	D'57'	; deg C for A/D D53(8-bit)
	retlw	D'57'	; deg C for A/D D54(8-bit)
	retlw	D'56'	; deg C for A/D D55(8-bit)
	retlw	D'56'	; deg C for A/D D56(8-bit)
	retlw	D'55'	; deg C for A/D D57(8-bit)
	retlw	D'54'	; deg C for A/D D58(8-bit)
	retlw	D'54'	; 54 deg C for A/D D59(8-bit)
	
	retlw	D'53'	; deg C for A/D D60(8-bit)
	retlw	D'53'	; deg C for A/D D61(8-bit)
	retlw	D'52'	; deg C for A/D D62(8-bit)
	retlw	D'52'	; deg C for A/D D63(8-bit)
	retlw	D'51'	; deg C for A/D D64(8-bit)
	retlw	D'50'	; deg C for A/D D65(8-bit)
	retlw	D'50'	; deg C for A/D D66(8-bit)
	retlw	D'50'	; deg C for A/D D67(8-bit)
	retlw	D'49'	; deg C for A/D D68(8-bit)
	retlw	D'49'	; deg C for A/D D69(8-bit)

	retlw	D'48'	; 48 deg C for A/D D70(8-bit)
	retlw	D'48'	; deg C for A/D D71(8-bit)
	retlw	D'47'	; deg C for A/D D72(8-bit)
	retlw	D'47'	; deg C for A/D D73(8-bit)
	retlw	D'46'	; deg C for A/D D74(8-bit)
	retlw	D'46'	; deg C for A/D D75(8-bit)
	retlw	D'45'	; deg C for A/D D76(8-bit)
	retlw	D'45'	; deg C for A/D D77(8-bit)
	retlw	D'44'	; deg C for A/D D78(8-bit)
	retlw	D'44'	; deg C for A/D D79(8-bit)

	retlw	D'43'	; deg C for A/D D80(8-bit)
	retlw	D'43'	; deg C for A/D D81(8-bit)
	retlw	D'43'	; deg C for A/D D82(8-bit)
	retlw	D'42'	; deg C for A/D D83(8-bit)
	retlw	D'42'	; deg C for A/D D84(8-bit)
	retlw	D'41'	; deg C for A/D D85(8-bit)
	retlw	D'41'	; deg C for A/D D86(8-bit)
	retlw	D'40'	; deg C for A/D D87(8-bit)
	retlw	D'40'	; deg C for A/D D88(8-bit)
	retlw	D'40'	; 40 deg C for A/D D89(8-bit)

	retlw	D'39'	; deg C for A/D D90(8-bit)
	retlw	D'39'	; deg C for A/D D91(8-bit)
	retlw	D'38'	; deg C for A/D D92(8-bit)
	retlw	D'38'	; deg C for A/D D93(8-bit)
	retlw	D'38'	; deg C for A/D D94(8-bit)
	retlw	D'37'	; deg C for A/D D95(8-bit)
	retlw	D'37'	; deg C for A/D D96(8-bit)
	retlw	D'36'	; deg C for A/D D97(8-bit)
	retlw	D'36'	; deg C for A/D D98(8-bit)
	retlw	D'36'	; deg C for A/D D99(8-bit)

	retlw	D'35'	; deg C for A/D D100(8-bit)
	retlw	D'35'	; deg C for A/D D101(8-bit)
	retlw	D'34'	; deg C for A/D D102(8-bit)
	retlw	D'34'	; deg C for A/D D103(8-bit)
	retlw	D'34'	; deg C for A/D D104(8-bit)
	retlw	D'33'	; deg C for A/D D105(8-bit)
	retlw	D'33'	; deg C for A/D D106(8-bit)
	retlw	D'33'	; deg C for A/D D107(8-bit)
	retlw	D'32'	; deg C for A/D D108(8-bit)
	retlw	D'32'	; 32 deg C for A/D D109(8-bit)

	retlw	D'32'	; deg C for A/D D110(8-bit)
	retlw	D'31'	; deg C for A/D D111(8-bit)
	retlw	D'31'	; deg C for A/D D112(8-bit)
	retlw	D'30'	; deg C for A/D D113(8-bit)
	retlw	D'30'	; deg C for A/D D114(8-bit)
	retlw	D'30'	; deg C for A/D D115(8-bit)
	retlw	D'29'	; deg C for A/D D116(8-bit)
	retlw	D'29'	; deg C for A/D D117(8-bit)
	retlw	D'29'	; deg C for A/D D118(8-bit)
	retlw	D'28'	; deg C for A/D D119(8-bit)

	retlw	D'28'	; deg C for A/D D120(8-bit)
	retlw	D'28'	; deg C for A/D D121(8-bit)
	retlw	D'27'	; deg C for A/D D122(8-bit)
	retlw	D'27'	; deg C for A/D D123(8-bit)
	retlw	D'27'	; deg C for A/D D124(8-bit)
	retlw	D'26'	; deg C for A/D D125(8-bit)
	retlw	D'26'	; deg C for A/D D126(8-bit)
	retlw	D'26'	; deg C for A/D D127(8-bit)
	retlw	D'25'	; deg C for A/D D128(8-bit)
	retlw	D'25'	; deg C for A/D D129(8-bit)

	retlw	D'24'	; deg C for A/D D130(8-bit)
	retlw	D'24'	; deg C for A/D D131(8-bit)
	retlw	D'24'	; deg C for A/D D132(8-bit)
	retlw	D'24'	; deg C for A/D D133(8-bit)
	retlw	D'23'	; deg C for A/D D134(8-bit)
	retlw	D'23'	; deg C for A/D D135(8-bit)
	retlw	D'23'	; deg C for A/D D136(8-bit)
	retlw	D'22'	; deg C for A/D D137(8-bit)
	retlw	D'22'	; deg C for A/D D138(8-bit)
	retlw	D'22'	; deg C for A/D D139(8-bit)

	retlw	D'21'	; deg C for A/D D140(8-bit)
	retlw	D'21'	; deg C for A/D D141(8-bit)
	retlw	D'21'	; deg C for A/D D142(8-bit)
	retlw	D'20'	; deg C for A/D D143(8-bit)
	retlw	D'20'	; deg C for A/D D144(8-bit)
	retlw	D'20'	; deg C for A/D D145(8-bit)
	retlw	D'19'	; deg C for A/D D146(8-bit)
	retlw	D'19'	; deg C for A/D D147(8-bit)
	retlw	D'19'	; deg C for A/D D148(8-bit)
	retlw	D'18'	; deg C for A/D D149(8-bit)

	retlw	D'18'	; deg C for A/D D150(8-bit)
	retlw	D'18'	; deg C for A/D D151(8-bit)
	retlw	D'17'	; deg C for A/D D152(8-bit)
	retlw	D'17'	; deg C for A/D D153(8-bit)
	retlw	D'17'	; deg C for A/D D154(8-bit)
	retlw	D'16'	; deg C for A/D D155(8-bit)
	retlw	D'16'	; deg C for A/D D156(8-bit)
	retlw	D'16'	; deg C for A/D D157(8-bit)
	retlw	D'15'	; deg C for A/D D158(8-bit)
	retlw	D'15'	; deg C for A/D D159(8-bit)

	retlw	D'15'	; deg C for A/D D160(8-bit)
	retlw	D'14'	; deg C for A/D D161(8-bit)
	retlw	D'14'	; deg C for A/D D162(8-bit)
	retlw	D'14'	; deg C for A/D D163(8-bit)
	retlw	D'13'	; deg C for A/D D164(8-bit)
	retlw	D'13'	; deg C for A/D D165(8-bit)
	retlw	D'13'	; deg C for A/D D166(8-bit)
	retlw	D'12'	; deg C for A/D D167(8-bit)
	retlw	D'12'	; deg C for A/D D168(8-bit)
	retlw	D'12'	; deg C for A/D D169(8-bit)

	retlw	D'11'	; deg C for A/D D170(8-bit)
	retlw	D'11'	; deg C for A/D D171(8-bit)
	retlw	D'11'	; deg C for A/D D172(8-bit)
	retlw	D'10'	; deg C for A/D D173(8-bit)
	retlw	D'10'	; deg C for A/D D174(8-bit)
	retlw	D'10'	; deg C for A/D D175(8-bit)
	retlw	D'9'	; deg C for A/D D176(8-bit)
	retlw	D'9'	; deg C for A/D D177(8-bit)
	retlw	D'8'	; deg C for A/D D178(8-bit)
	retlw	D'8'	; 8 deg C for A/D D179(8-bit)

	retlw	D'8'	; deg C for A/D D180(8-bit)
	retlw	D'7'	; deg C for A/D D181(8-bit)
	retlw	D'7'	; deg C for A/D D182(8-bit)
	retlw	D'7'	; deg C for A/D D183(8-bit)
	retlw	D'6'	; deg C for A/D D184(8-bit)
	retlw	D'6'	; deg C for A/D D185(8-bit)
	retlw	D'6'	; deg C for A/D D186(8-bit)
	retlw	D'5'	; deg C for A/D D187(8-bit)
	retlw	D'5'	; deg C for A/D D188(8-bit)
	retlw	D'4'	; 4 deg C for A/D D189(8-bit)

	retlw	D'4'	; deg C for A/D D190(8-bit)
	retlw	D'4'	; deg C for A/D D191(8-bit)
	retlw	D'3'	; deg C for A/D D192(8-bit)
	retlw	D'3'	; deg C for A/D D193(8-bit)
	retlw	D'2'	; deg C for A/D D194(8-bit)
	retlw	D'2'	; deg C for A/D D195(8-bit)
	retlw	D'2'	; deg C for A/D D196(8-bit)
	retlw	D'1'	; deg C for A/D D197(8-bit)
	retlw	D'1'	; deg C for A/D D198(8-bit)
	retlw	D'0'	; deg C for A/D D199(8-bit)
; 0 deg C min
	retlw	D'0'	; 0 deg C for A/D D200(8-bit)

; **********************************************************************************************

SETUP
	
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11110000'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'10101111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000000'	; settings (pullups enabled)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'01101111'		; AN0 to AN3 and AN5 and AN6 are analog inputs
	movwf	ANSEL
	movlw	B'11000000'		; right justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	clrf		PORTB			; port B outputs low
	clrf		PORTA			; port A outputs low
	movlw	B'01101000'	;	 Fosc, channel 5 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01111000'		; 8MHz
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; memory bank 0
; timer 1
	bsf		T1CON,0		; timer 1 on
	
; initial conditions
INITIAL
	clrf		CHARGE_RATE		; zero charge rate to begin
	clrf		CHARGE_STATE	; charge status
	clrf		FLASHER			; LED flasher
	clrf		THERMISTOR		; thermistor flags
 	clrf 		CHARGE_CONT		; charge controller
	clrf		MINUTES			; minutes counter
	clrf		CHARGE_PULSE	; charge rate counter
	clrf		AD_COUNT			; A/D conversion counter
	clrf		ONCE				; once flag
	clrf		LITHIUM				; end of charge flag for Lithium

; relay on
	bsf		PORTA,6

; initially set 
	bsf		CHARGE_FLAG,0	; start at no charging
	bsf		END_FLG,0			; a/d run flag runs at startup
	bsf		END_FLG,1			; 5-seconds
	bsf		PORTB,0			; Charge LED on

; set 1 hour counter at start of charge
	movlw	D'1'
	movwf	HOUR				; timer set

; set battery discharge timer for x hours
; *** timeout for battery connected but charger off change value here only
	movlw	D'2'
	movwf	HOUR2				; battery discharge timer
	movwf	HOUR3				; stored hour value

; Alternate charge LED status if S2 is pressed
; check store switch S2 if closed toggle charge show status
	movlw	EEPROM10
	call		EEREAD
	movwf	CHRG_SHOW		; charge show status
	btfsc	PORTB,5			; if switch is closed, level is low
	goto	ALLOW_INTERRUPTS; not closed
	incf		CHRG_SHOW,f		; alter bit 0
	movlw	EEPROM10
	call		EEREAD			; sets EEADR
	movf	CHRG_SHOW,w		; setting
	call		EEWRITE			; store in EEPROM
FLASH_ACK
	bsf		PORTB,0			; charge LED on
	movlw	D'2'
	call	DELAY_1
	bcf		PORTB,0			; LED off
	movlw	D'2'
	call	DELAY_1
	bsf		PORTB,0			; charge LED on
	movlw	D'2'
	call	DELAY_1
	bcf		PORTB,0			; LED off
	movlw	D'2'
	call	DELAY_1
	bsf		PORTB,0			; charge LED on
	movlw	D'2'
	call	DELAY_1
	bcf		PORTB,0			; LED off
	movlw	D'2'
	call		DELAY_1
	btfss	PORTB,5			; wait till switch is open
	goto	FLASH_ACK			; acknowledge switch pressing
	call		DELAY

ALLOW_INTERRUPTS
; allow interrupts
	bsf		STATUS,RP0		; select memory bank 1
	bsf		PIE1,TMR1IE			; timer 1 overflow interrupt
	bcf		STATUS,RP0		; select memory bank 0
	bcf		PIR1,TMR1IF			; timer 1 interrupt flag
	bsf		INTCON,PEIE		; enable periperal interrupts 	 
	bsf		INTCON,GIE
	goto	PRE_ADJ
CYCLE							; code start of run cycle returns here
	bsf		ONCE,0				; set to show LEDs next time

; check for Lithium charge end
	btfsc	LITHIUM,0			; if set end of charge
	goto	BATT_TRACK		; track battery voltage

PRE_ADJ ; check if preset or adjustable 
; Check JP1, default or adjustable

	btfss	PORTB,4			; preset or adjustable
	goto	ADJUST1

PRESET1; Use  preset values

; check if SLA, Lead Acid or Lithium

	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	movwf	TEMP
	movf	TEMP,w
	btfsc	STATUS,Z		; if zero, SLA
	goto	SLA1			;  SLA selection

	xorlw	D'01'			; if 1, Lead Acid
	btfsc	STATUS,Z		
	goto	LEAD_ACID1

LiFePO4
; load LiFePO4 preset values
;	H'01', H'D1'			 ; cutoff 13.88V,  no float, no compensation LiFePO4

	movlw	H'01'
	movwf	CUT_M		; cutout SLA voltage high byte 13.88V (cutout voltage /30.5 x 1023 as Hex value)
	movlw	H'D1'
	movwf	CUT_L		; cutout SLA voltage low byte
	movlw	H'00'
	movwf	FLOAT_H	; No  float SLA voltage high byte  
	movlw	H'00'
	movwf	FLOAT_L	; No float SLA voltage low byte
	movlw	D'0'
	movwf	COMP		; 0mV/deg C SLA compensation
	goto	AD1

SLA1
; load SLA preset values
;	H'01', H'D9', H'01', H'C5', D'128'; cutoff 14.1, float 13.5 and compensation -25mV SLA

	movlw	H'01'
	movwf	CUT_M		; cutout SLA voltage high byte 14.1V (cutout voltage /30.5 x 1023 as Hex value)
	movlw	H'D9'
	movwf	CUT_L		; cutout SLA voltage low byte
	movlw	H'01'
	movwf	FLOAT_H	; float SLA voltage high byte 13.5V (float voltage/30.5 x 1023 as Hex value)
	movlw	H'C5'
	movwf	FLOAT_L	; float SLA voltage low byte
	movlw	D'128'
	movwf	COMP		; -25mV/deg C SLA compensation
	goto	AD1
	
LEAD_ACID1
; load L/A preset values
;	H'01', H'E3', H'01', H'CF', D'102'; cutoff 14.4, float 13.8 and compensation -20mV Lead Acid

	movlw	H'01'
	movwf	CUT_M		; cutout LA voltage high byte 14.4V (cutout V/16 x 1023 as Hex value)
	movlw	H'E3'
	movwf	CUT_L		; cutout LA voltage low byte
	movlw	H'01'
	movwf	FLOAT_H	; float LA voltage high byte 13.8V (float V /16 x 1023 as Hex value)
	movlw	H'CF'
	movwf	FLOAT_L	; float LA voltage low byte
	movlw	D'102'
	movwf	COMP		; -20mV/deg C LA compensation
	goto	AD1	

ADJUST1; Adjustable values

; check if SLA, Lead Acid or Lithium

	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	movwf	TEMP
	movf	TEMP,w
	btfsc	STATUS,Z		; if zero, SLA
	goto	SLA2			;  SLA selection

	xorlw	D'01'			; if 1, Lead Acid
	btfsc	STATUS,Z		
	goto	LEAD_ACID2

LiFePO4_2
; load LiFEPO4 adjustable values
	movlw	EEPROMA
	call	EEREAD
	movwf	CUT_M			; cutout SLA voltage high byte 
	movlw	EEPROMB
	call	EEREAD
	movwf	CUT_L			; cutout SLA voltage low byte
	movlw	EEPROMC
	call	EEREAD
	movwf	FLOAT_H		; float SLA voltage high byte, set at 0
	movlw	EEPROMD
	call	EEREAD
	movwf	FLOAT_L		; float SLA voltage low byte, set at 0
	movlw	EEPROME
	call	EEREAD
	movwf	COMP			; -X mV/deg C SLA compensation, set at 0
	goto	AD1

SLA2
; load SLA adjustable values
	movlw	EEPROM0
	call	EEREAD
	movwf	CUT_M			; cutout SLA voltage high byte 
	movlw	EEPROM1
	call	EEREAD
	movwf	CUT_L			; cutout SLA voltage low byte
	movlw	EEPROM2
	call	EEREAD
	movwf	FLOAT_H		; float SLA voltage high byte 
	movlw	EEPROM3
	call	EEREAD
	movwf	FLOAT_L		; float SLA voltage low byte
	movlw	EEPROM4
	call	EEREAD
	movwf	COMP			; -X mV/deg C SLA compensation
	goto	AD1
	
LEAD_ACID2
; load LA adjustable values
	movlw	EEPROM5
	call	EEREAD
	movwf	CUT_M			; cutout LA voltage high byte 
	movlw	EEPROM6
	call	EEREAD
	movwf	CUT_L			; cutout LA voltage low byte
	movlw	EEPROM7
	call	EEREAD
	movwf	FLOAT_H		; float LA voltage high byte 
	movlw	EEPROM8
	call	EEREAD
	movwf	FLOAT_L		; float LA voltage low byte
	movlw	EEPROM9
	call	EEREAD
	movwf	COMP			; -X mV/deg C LA compensation

; update A/D values

AD1
; Channel 1 A/D value (CHARGE RATE)
CH_1AD

; charge or absorp/float
CHRG_AB_FLT
	movf	CHARGE_STATE,w
	btfss	STATUS,Z
	goto	AB_FLOAT
; charge. Compare charge rate value 
	movf	CHARGE_RATE,w
	sublw	D'99'			; if at max then update with end_flag,1
	btfsc	STATUS,C
	goto	BY_EQUAL		; not at max so update on END_FLG,0
	btfss	END_FLG,1		; only read when 2-seconds is up for max charge rate
	goto	CHECK_MODE	; bypass
	goto	BY_EQUAL1		; 2-second update

AB_FLOAT ; absorption or float
; charge compare charge control value 
	movf	CHARGE_CONT,w
	sublw	D'99'			; if at max then update with end_flag,1
	btfsc	STATUS,C
	goto	BY_EQUAL		; not at max so update on END_FLG,0
	btfss	END_FLG,1		; only read when 2-seconds is up for max charge rate
	goto	CHECK_MODE	; bypass
	goto	BY_EQUAL1
	
BY_EQUAL
	btfss	END_FLG,0		; only read when charge rate cycle completed
	goto	CHECK_MODE	
BY_EQUAL1
	bcf		END_FLG,0		; do once until the flags are reset
	bcf		END_FLG,1
	bcf		END_FLG,2		; conversion flag
; set analog input address
; AN1 Charge % setting

	bcf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; A/D No.1

	bcf		STATUS,GIE		; prevent Mosfet drive changes
	bcf		PORTB,3		; drive off

	call		DEL			; time for inputs to settle
	bsf		ADCON0,2		; GO/DONE bit start conversion
	
WAIT_CONV5
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV5
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	DIGITAL
; change from 10-bit to 8-bit bit 9 never set because <2.5V
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right

; convert to 0-100% with 0-1V = 0-100% and 0-102 = 0-100%
; 1V = D51 but because only shifted right by one then D102=1V
	movf	DIGITAL,w		; 1V
	sublw	D'100'			; take away if - then set at 100% 
	movf	DIGITAL,w		; digital value to w ready to load if not 101 or more, instead of subtraction
	btfss	STATUS,C		; if negative
	movlw	D'100'			; set at 100
	movwf	CHARGE_RATE1	; charge rate 0-100% 
; compare with last value
	xorwf	CHARGE_RATE2,w
	btfss	STATUS,Z		; if the same use for charge rate
	goto	TRANSF_RATE
	movf	CHARGE_RATE1,w
	movwf	CHARGE_RATE		; actual value used
TRANSF_RATE
	movf	CHARGE_RATE1,w
	movwf	CHARGE_RATE2	; transfer ready for next comparison


;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; if LiFePO4 then bypass temperature adjustments after transferring values to COMP registers
;
; check if SLA, Lead Acid or Lithium at JP3

	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	xorlw	D'02'	
	btfss	STATUS,Z		; LiFePO4 when w is a 2	
	goto	CH_2AD		; SLA or Lead Acid so use temperature compensation

; LiFePO4
	movf	CUT_L,w
	movwf	CUT_COMP_L
	movf	CUT_M,w		; ms cutout V
	movwf	CUT_COMP_M	  	
	goto	BATT_TRACK	; bypassing temperature compensation. Check battery

; Channel 2 A/D value (temperature)
CH_2AD
; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3		; A/D No.2
	call		DEL			; delay time for inputs to settle
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	DIGITAL
; change from 10-bit to 8-bit
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right

; check for thermistor out of circuit

	movf	DIGITAL,w
	sublw	D'250'			; >250
	clrf		THERMISTOR
	btfsc	STATUS,C
	goto	CK_ZRO
	bsf		THERMISTOR,0	; set when out of circuit
	goto	BY_ZRO
; check for zero degrees or less
CK_ZRO
	movf	DIGITAL,w
	sublw	D'199'			; >199
	btfss	STATUS,C
	bsf		THERMISTOR,1	; set when 0 degrees or less

; check for thermistor short circuit
	movlw	D'04'
	subwf	DIGITAL,w		; if less than 4
	btfss	STATUS,C
	bsf		THERMISTOR,0	; set when short circuit

BY_ZRO
TEMP_CONV1	
; convert to temperature
	movf	DIGITAL,w
	sublw	D'199'			; take from 199 if negative then >200 so set at 200
	movlw	D'200'			; ready to load if >200
	btfss	STATUS,C
	movwf	DIGITAL
	movlw	D'49'			; minimum value
	subwf	DIGITAL,f		; take away 49 from A/D value
	btfss	STATUS,C		; if minus then >60 deg C so set at 60deg
	clrf		DIGITAL			; 0 so 60 deg C in lookup table
	movf	DIGITAL,w
	call		TEMP_CONV		; convert reading to temperature in deg C
	movwf	TEMPERATURE		; store value

; find compensation requirement with temperature difference from 20 deg C
; COMP_SLA or COMP_LA x temp difference
; multiplied by D100 and divided by D15146 to calculate mV/deg C for cutout and float voltages (based on 6.1 division for battery and D127 A/D = 25mV/deg C. Battery used 10bit (1023))
; this is added (for <20 deg C) or subtracted (for >20deg C) from cutoff and float Voltages. 	

; take away 20 deg C
	clrf		NEGATIVE		; subtract flag
	movlw	D'20'			; 20 deg C
	subwf	TEMPERATURE,w	;
	btfss	STATUS,C		; if negative then less than 20 deg C
	bsf		NEGATIVE,7
; (temperature - 20) x 100
	movwf	AARGB0
; if negative then subtract from 20
	btfss	NEGATIVE,7
	goto	CONTINUE1
	movf	TEMPERATURE,w
	sublw	D'20'			; temperature from 20
	movwf	AARGB0

CONTINUE1
; multiply temperature difference from 20 deg C (in AARGB0) by compensation value
	movf	COMP,w
	movwf	BARGB0
	call		EIGHTEIGHT
; result in AARGB0,AARGB1	
; shift result
	movf	AARGB1,w
	movwf	AARGB2
	movf	AARGB0,w
	movwf	AARGB1
	clrf		AARGB0 
; Multiply by 100
	movlw	D'100'
	movwf	BARGB2
	clrf		BARGB1
	clrf		BARGB0
	call		FXM2424U		; multiply
; shift result for division	
	movf	AARGB2,w		; ms of multiplication
	movwf	AARGB0
	movf	AARGB3,w		; ls byte
	movwf	AARGB1
	movf	AARGB4,w		; ms of multiplication
	movwf	AARGB2
	movf	AARGB5,w		; ls byte
	movwf	AARGB3
; Divide by D15146 = H3B2A
	clrf		BARGB0
	clrf		BARGB1
	movlw	H'3B'
	movwf  	BARGB2
	movlw	H'2A'
	movwf	BARGB3	
	call		FXD3232U		; divide

; cutoff calculations
	btfsc	NEGATIVE,7		; if set add value
	goto	ADD_COMP1
; take compensation value from cutoff V and place in CUT_COMP_M/LS 
	movf	AARGB3,w		; result
	subwf	CUT_L,w
	movwf	CUT_COMP_L
	movf	CUT_M,w			; ms cutout V
	btfss	STATUS,C
	decf	CUT_M,w			; decrease if carry
	movwf	CUT_COMP_M	  	
	btfss	CUT_COMP_M,7	; if bit 7 set then over so clear 
	goto	CHECK_FLOAT
	clrf		CUT_COMP_M
	clrf		CUT_COMP_L
	goto	CHECK_FLOAT

ADD_COMP1
	movf	CUT_M,w	
	movwf	CUT_COMP_M
	movf	AARGB3,w		; result
	addwf	CUT_L,w
	movwf	CUT_COMP_L
	btfsc	STATUS,C
	incf		CUT_COMP_M,f	; increase if carry

; check if over 1024
	btfss	CUT_COMP_M,2	; if bit set over so set at 1023 	  	
	goto	CHECK_FLOAT
	movlw	B'00000011'		; set at 1023
	movwf	CUT_COMP_M
	movlw	H'FF'
	movwf	CUT_COMP_L

; Float calculations
CHECK_FLOAT
	btfsc	NEGATIVE,7		; if set add value
	goto	ADD_COMP2

 ; take compensation value from float V and place in FLOAT_COMP_M/LS
	movf	AARGB3,w		; result
	subwf	FLOAT_L,w
	movwf	FLOAT_COMP_L
	movf	FLOAT_H,w		; ms float V
	btfss	STATUS,C
	decf	FLOAT_H,w		; decrease if carry
	
	movwf	FLOAT_COMP_M	  	
	btfss	FLOAT_COMP_M,7	; if bit 7 set then over so clear 
	goto	BATT_TRACK
	clrf		FLOAT_COMP_M
	clrf		FLOAT_COMP_L
	goto	BATT_TRACK

ADD_COMP2
	movf	FLOAT_H,w		; ms float V to w 
	movwf	FLOAT_COMP_M
	movf	AARGB3,w		; result
	addwf	FLOAT_L,w
	movwf	FLOAT_COMP_L
	btfsc	STATUS,C
	incf		FLOAT_COMP_M,f		; increase if carry

; check if over 1024
	btfss	FLOAT_COMP_M,2	; if bit set over so set at 1023 	  	
	goto	BATT_TRACK
	movlw	B'00000011'		; set at 1023
	movwf	FLOAT_COMP_M
	movlw	H'FF'
	movwf	FLOAT_COMP_L

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; keep track of battery voltage. If it drops below setting (check cut off value for battery voltage) then switch off relay (at RA6) and after x hours
BATT_TRACK

	movf	CUT_M,w		; high byte of battery voltage if 0= 6V, 1= 12V and 3= 24V
	btfsc	STATUS,Z		; when 0 a 6V battery
	goto	SIX_CHK
	xorlw	D'1'				; check for a 1
	btfsc	STATUS,Z		; when =1 then a 12V battery
	goto	TWELVE_CHK

	movf	CUT_M,w
	xorlw	D'3'				; when a 3 then assume 24V battery
	btfsc	STATUS,Z
	goto	TWENTY_FOUR
	goto	CH_3AD		; a 2 so indeterminate

TWENTY_FOUR
; H324 is 24V so check battery Voltage	
;  a 24V battery
; check battery is above 25V
; if batt drops to required value, allow timer to decrease. If battery over, set timer.
; check if below 25V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'3'				; take from 25V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'46'			; 25V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >24V
	goto	CH_3AD
	movf	HOUR3,w		; value for timeout. keep hour set when above 24V
	bcf		INTCON,GIE		; prevent change during interrupt
	movwf	HOUR2
	bsf		INTCON,GIE
	goto	CH_3AD

TWELVE_CHK	
; H192 is 12V so check battery Voltage	
;  a 12V battery
; check battery is above 12.5V
; if batt drops to required value, allow timer to decrease. If battery over, set timer.
; check if below 12.5V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'1'				; take from 12.5V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'A3'			; 12.5V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >12V
	goto	CH_3AD
	movf	HOUR3,w		; value for timeout. keep hour set when above 12V
	bcf		INTCON,GIE		; prevent change during interrupt
	movwf	HOUR2
	bsf		INTCON,GIE
	goto	CH_3AD


SIX_CHK

; HC9 is 6V so check battery Voltage	
;  a 6V battery
; check battery is above 6.25V
; if batt drops to required value, allow timer to decrease. If battery over, set timer.
; check if below 6.25V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'0'				; take from 6.25V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'D1'			; 6.25V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >6V
	goto	CH_3AD
	movf	HOUR3,w		; value for timeout. keep hour set when above 6V
	bcf		INTCON,GIE		; prevent change during interrupt
	movwf	HOUR2
	bsf		INTCON,GIE
;	goto	CH_3AD


CH_3AD
; test timer first
;  when timer is cleared to 0 (counts down in interrupt ) switch off relay
	movf	HOUR2,w		; battery is below low value for 1hour if clear
	btfsc	STATUS,Z
; POWER OFF
	bcf		PORTA,6		; relay off so power off 

;  Channel 3 A/D battery voltage
; voltage at AN3 is 0.1639 of actual measured due to divider
; this value predetermines the other cutoff, float and compensation calculations to match this calibration
; of voltage measurement

; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bsf		ADCON0,3		; A/D No.3
	call		DEL
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV3
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV3

	bsf		STATUS,GIE		; allow interrups 
	bsf		PORTB,3		; Mosfet drive

	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	BATT_LO			; battery low byte
	movf	ADRESH,w		; 
	movwf	BATT_HI

; add D8 (0.25V) to battery voltage for fast slow control
	movf	BATT_HI,w	
	movwf	BATT_P8H		; high byte of plus 8
	movlw	D'8'				; add value
	addwf	BATT_LO,w
	movwf	BATT_P8L
	btfsc	STATUS,C
	incf		BATT_P8H,f		; increase if carry

; check if over 1024
	btfss	BATT_P8H,2		; if bit set over so set at 1023 	  	
	goto	MINUS8
	movlw	B'00000011'		; set at 1023
	movwf	BATT_P8H
	movlw	H'FF'
	movwf	BATT_P8L

; subtract D'8' (0.25V) to battery voltage for slow control
MINUS8
	movlw	D'8'				; 8
	subwf	BATT_LO,w		; low byte subtract first
	movwf	BATT_M8L
	movf	BATT_HI,w		; ms batt V
	btfss	STATUS,C
	decf	BATT_HI,w		; decrease if carry
	movwf	BATT_M8H	  	
	btfss	BATT_M8H,7		; if bit 7 set then over so clear 
	goto	CHECK_MODE
	clrf		BATT_M8H
	clrf		BATT_M8L

CHECK_MODE
; if LiFePO4 ignore thermistor

	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4

	xorlw	D'02'	
	btfsc	STATUS,Z		
	goto	CHK_BATT		; bypass thermistor if LiFePO4

; if THERMISTOR,1 set (< 0deg C) then charge off so set charge_flag,0
	btfss	THERMISTOR,1	; 0 degrees
	goto	CHK_ZRO_BIT
	bsf		CHARGE_FLAG,0	; set charge flag so no charge if <0 deg C
	goto	STORE_SWITCH	; check if store switch is pressed
CHK_ZRO_BIT
	btfss	THERMISTOR,0	; thermistor out
	goto	CHK_BATT
	bsf		CHARGE_FLAG,0	; set charge flag so no charge if <0 deg C
	goto	STORE_SWITCH	; check if store switch is pressed

CHK_BATT 
; if battery at 0V no charge
	movf	BATT_HI,w		; if zero
	btfss	STATUS,Z		; ms byte not zero so bypass test
	goto	NOT_ZRO_BATT
	movf	BATT_LO,w
	btfss	STATUS,Z		; H'0000'
	goto	CHK_1_BATT
CHRG_BATT_0_OFF
	bsf		CHARGE_FLAG,0	; stop charging
	bcf		PORTB,0			; charge LED off
	goto	STORE_SWITCH
CHK_1_BATT
	xorlw	D'01'			; test for (zero as above or a H'01')
	btfsc	STATUS,Z
	goto	CHRG_BATT_0_OFF


NOT_ZRO_BATT

; 10.5V (D352, H160) or 21V (D704, H2C0) test depends on CUT_M and CUT_L values for 12 or 24V batteries
; battery if low then apply bursts till >10.5V or 21V. Also tests 6V battery for <5.25V

	movf	CUT_M,w			; most significant byte of cutoff voltage
	xorlw	H'1'					; if a 1 then using 12V battery
	btfss	STATUS,Z
	goto	BY_10.5				; not 12V so bypass 10.5V test

;  12V so check for low battery
; check if below 10.5V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'1'				; take from 10.5V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'60'			; 10.5V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >10.5V
	goto	BURST	
	goto	CHRG_MD

BY_10.5
; 24V so check low battery for <21V
	movf	CUT_M,w			; most significant byte of cutoff voltage
	xorlw	H'3'					; if a 3 then using 24V battery
	btfss	STATUS,Z
	goto	TEST6V				; test for low battery for 6V

; check if below 21V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'2'				; take from 21V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'C0'			; 21V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >21V
	goto	BURST	
	goto	CHRG_MD

TEST6V
; check if CUT_M is 0 for a 6V battery. If not got to CHARGE_MD
	movf	CUT_M,w
	btfss	STATUS,Z
	goto	CHRG_MD		; must be 2 so 24V
		
; check if below 5.25V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'0'				; take from 5.25V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'B0'			; 5.25V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >5.25V
	goto	BURST	

; charge mode
CHRG_MD
	clrf		CHARGE_FLAG		; allows charging
	movf	CHARGE_STATE,w	; 0 charge, 1 absorption and 2 float
	btfsc	STATUS,Z
	goto	CHARGE_FULL
; check if battery voltage has been remeasured
	btfsc	END_FLG,2
	goto	STORE_SWITCH
	bsf		END_FLG,2		; set once accepted
	xorlw	D'01'			; absorption
	btfss	STATUS,Z		;
	goto	CHARGE_FLOAT

CHARGE_ABSORPTION; (CHARGE_STATE = 1)
	btfsc	CHRG_SHOW,0		; if set bypass clearing charge LED 
	bcf		PORTB,0			; Charge LED off
	bsf		PORTB,1			; absorption LED on
	bcf		PORTB,2			; float LED off

; maintain cutout voltage for 1 hour
; check when HOUR timer finished
	movf	HOUR,w
	btfsc	STATUS,Z			; when zero change to float
	goto	CHARGE_FLOAT	; float mode

; Switch to float when CHARGE_CONT (actual % required to maintain the set voltage) is 3% or less than CHARGE_RATE (the bulk charge % setting)
; divide by 16
	swapf	CHARGE_RATE,w	; place ms 4-bits in ls side
	andlw	B'00001111'			; remove upper bits
	movwf	COMPARE
	bcf		STATUS,C
	rrf		COMPARE,f		; divide by 2 for a total division of 32 for ~3% (actual 3.125%)		
; compare with CHARGE_CONT
	movf	COMPARE,w
	subwf	CHARGE_CONT,w
	btfss	STATUS,C		; if negative, then charge control is <3%,  so float
	goto	CHARGE_FLOAT
	btfsc	STATUS,Z		; if equal then float
	goto	CHARGE_FLOAT

ADJ_DRV
; use CHARGE_CONT to adjust the drive to maintain cutout Voltage 
; compare battery with cutout V

; if battery voltage is D1023 (H3FF) then over in value
	movf	BATT_HI,w		; ms byte
	xorlw	H'03'			; 3
	btfss	STATUS,Z
	goto	TEST_BATT
	movf	BATT_LO,w
	xorlw	H'FF'
	btfsc	STATUS,Z	
	goto	CHARGE_FLOAT	; equal to 1023 so float
TEST_BATT
	movf	BATT_HI,w		; high byte of battery voltage
	subwf	CUT_COMP_M,w	; take from compensated cutout
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	subwf	CUT_COMP_L,w	; take from compensated cutout
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >
	goto	INC_CHARGE_CONT1
; decrease charge control
DEC_CHRG1
	movf	CHARGE_CONT,w
	btfsc	STATUS,Z		; if zero leave at 0
	goto	STORE_SWITCH	; bypass decrease
; check if fast or slow requirement (compare with subtracted battery value) 
	movf	BATT_M8H,w		; high byte of battery voltage
	subwf	CUT_COMP_M,w 	; take from compensated cutout V
	movwf	DIGITAL			; store
	movf	BATT_M8L,w		; low byte
	subwf	CUT_COMP_L,w	; take from compensated cutout V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfsc	DIGITAL,7		; if set then >
	goto	FAST_CUT_DEC
; slow change because battery voltage is within 0.25V window
SLOW4
	movf	CHARGE_CONT,w
	btfss	STATUS,Z
	decf	CHARGE_CONT,f	; decrease if not 0
	goto	STORE_SWITCH
; fast change because battery voltage is outside 0.25V window
FAST_CUT_DEC
	movlw	D'15'
	subwf	CHARGE_CONT,w	; decrease 
	btfss	STATUS,C		; if negative use slow 
	goto	SLOW4
	movwf	CHARGE_CONT
	goto	STORE_SWITCH	; bypass decrease

INC_CHARGE_CONT1
; check if fast or slow requirement (compare with added battery voltage)

	movf	BATT_P8H,w		; high byte of battery voltage
	subwf	CUT_COMP_M,w 	; take from compensated float
	movwf	DIGITAL				; store
	movf	BATT_P8L,w		; low byte
	subwf	CUT_COMP_L,w		; take from compensated float V
	btfss	STATUS,C
	decf	DIGITAL,f			; decrease if required
	btfss	DIGITAL,7			; if set then >
	goto	FAST_CUT_INC
; slow rate
SLOW1
	incf		CHARGE_CONT,w
	subwf	CHARGE_RATE,w	; stop at charge rate max
	btfss	STATUS,C
	goto	SET_CHARGE		; set value to charge rate
	incf		CHARGE_CONT,f
	goto	STORE_SWITCH
; fast rate increase
FAST_CUT_INC
	movlw	D'3'					; increase by 3
	addwf	CHARGE_CONT,w
	subwf	CHARGE_RATE,w	; stop at charge rate max
	btfss	STATUS,C
	goto	SLOW1				; set value to charge rate if at max test at slow
	movlw	D'3'					; increase is not over value so increase charge control
	addwf	CHARGE_CONT,f
	goto	STORE_SWITCH

CHARGE_FULL; (CHARGE_STATE = 0)
; Charge LED lit according to % drive 
	bcf		PORTB,1			; absorption and float LEDs off
	bcf		PORTB,2

; check if battery voltage has been remeasured
	btfsc	END_FLG,2
	goto	STORE_SWITCH
	bsf		END_FLG,2			; set once accepted

; if battery voltage is D1023 (H3FF) then over in value
	movf	BATT_HI,w			; ms byte
	xorlw	H'03'				; 3
	btfss	STATUS,Z
	goto	TEST_BATT2		; not equal
	movf	BATT_LO,w
	xorlw	H'FF'
	btfsc	STATUS,Z	
	goto	BATT_HI1			; battery voltage high so end charge
TEST_BATT2
; compare battery voltage (BATT_HI/LO) with cutout (CUT_COMP_M/L)
	movf	BATT_HI,w			; high byte of battery voltage
	subwf	CUT_COMP_M,w		; take from compensated cutout
	movwf	DIGITAL				; store
	movf	BATT_LO,w			; low byte
	subwf	CUT_COMP_L,w		; take from compensated cutout
	btfss	STATUS,C
	decf	DIGITAL,f			; decrease if required
	btfss	DIGITAL,7			; if set then >
	goto	STORE_SWITCH
BATT_HI1
	movf	CHARGE_RATE,w	; transfer charge rate to control 
	movwf	CHARGE_CONT
	clrf		CHARGE_CONT1
    	bcf		PORTB,0			; charge LED off 


; check if Lithium (see JUMPER3 subroutine) then stop or absorption depending on JP2
; check if SLA, Lead Acid or Lithium at JP3

	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	xorlw	D'02'	
	btfss	STATUS,Z		; LiFePO4 when w is a 2	
	goto	ABS
; Lithium so check JP2. If high at RA5 then standard. If low then run absorption.
	btfss	PORTA,5
	goto	ABS			; absorption run
	bsf		LITHIUM,0		; set flag to stop charge
	goto	Li_END			; no absorption so charge complete
	
ABS; absorption
; when over, check if absorption (PORTA,5) if high: standard, low: absorption
	btfsc	PORTA,5			; set is standard so float
	goto	CHARGE_FLOAT	; go to float mode

; *** include this instruction line to allow absorption with less than 1-hour charging 
;	clrf	HOUR			; clear HOUR counter so absorption starts for charge period @ < 1-hour

; if hour counter still 1 then bypass absorption
	movf	HOUR,w				; hour timer set to 1 at full charge start
	btfss	STATUS,Z			; if timed out (zero) then absorption allowed
	goto	CHARGE_FLOAT	; bypass absorption and go to float charge because full charge in < 1 hour

; set to absorption and re-load HOUR counter 
	movlw	D'1'
	movwf	HOUR				; timer set
	clrf		SECONDS
	clrf		MINUTES			; clear counters
	movlw	D'01'				; absorption mode
	movwf	CHARGE_STATE	
	goto	STORE_SWITCH

CHARGE_FLOAT; (CHARGE_STATE = 2)

;  check if Lithium (see JUMPER3 subroutine) then stop charge if so
	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	xorlw	D'02'	
	btfss	STATUS,Z		; LiFePO4 when w is a 2
	goto	CONT_FLOAT
	bsf		LITHIUM,0		; set flag to stop charge
	goto	Li_END			; no absorption so charge complete

CONT_FLOAT

	btfsc	CHRG_SHOW,0		; if set bypass clearing charge LED 
	bcf		PORTB,0			; Charge LED off
	bcf		PORTB,1			; absorption LED off
	bsf		PORTB,2			; float LED on

	movlw	D'02'
	movwf	CHARGE_STATE	; float mode set when coming from full and absorption modes

; if battery voltage is D1023 (H3FF) then over in value
	movf	BATT_HI,w			; ms byte
	xorlw	H'03'				; 3
	btfss	STATUS,Z
	goto	TEST_BATT3		; not equal
	movf	BATT_LO,w
	xorlw	H'FF'
	btfss	STATUS,Z	
	goto	TEST_BATT3		; battery voltage not high 
; battery volts over so no charge
	clrf		CHARGE_CONT
	movlw	D'6'
	call		DELAY_1			; delay so LED flashes	
	bcf		PORTB,2			; float LED off
	goto	STORE_SWITCH

TEST_BATT3

; alter CHARGE_CONT to adjust the drive to maintain float V (D102 is maximum for CHARGE_CONT)

; compare battery with float V
	movf	BATT_HI,w			; high byte of battery voltage
	subwf	FLOAT_COMP_M,w 	; take from compensated float
	movwf	DIGITAL				; store
	movf	BATT_LO,w			; low byte
	subwf	FLOAT_COMP_L,w	; take from compensated float V
	btfss	STATUS,C
	decf	DIGITAL,f			; decrease if required
	btfss	DIGITAL,7			; if set then >
	goto	INC_CHARGE_CONT2
; decrease charge control
	movf	CHARGE_CONT,w
	btfsc	STATUS,Z			; if zero leave at 0
	goto	STORE_SWITCH		; bypass decrease
; check if fast or slow requirement (compare with subtracted battery value) 
	movf	BATT_M8H,w		; high byte of battery voltage
	subwf	FLOAT_COMP_M,w 	; take from compensated float
	movwf	DIGITAL				; store
	movf	BATT_M8L,w		; low byte
	subwf	FLOAT_COMP_L,w	; take from compensated float V
	btfss	STATUS,C
	decf	DIGITAL,f			; decrease if required
	btfsc	DIGITAL,7			; if set then >
	goto	FAST_FLOAT_DEC
; slow change because battery voltage is within 0.25V window
SLOW3
	movf	CHARGE_CONT,w
	btfss	STATUS,Z			; if zero no decrease
	decf	CHARGE_CONT,f	; decrease if not 0
	goto	STORE_SWITCH
; fast change because battery voltage is outside 0.25V window
FAST_FLOAT_DEC
	movlw	D'15'
	subwf	CHARGE_CONT,w	; decrease 
	btfss	STATUS,C			; if negative use slow rate 
	goto	SLOW3
	movwf	CHARGE_CONT
	goto	STORE_SWITCH		; bypass decrease

INC_CHARGE_CONT2
; check if fast or slow requirement (compare with added battery voltage)

	movf	BATT_P8H,w		; high byte of battery voltage
	subwf	FLOAT_COMP_M,w 	; take from compensated float
	movwf	DIGITAL				; store
	movf	BATT_P8L,w		; low byte
	subwf	FLOAT_COMP_L,w	; take from compensated float V
	btfss	STATUS,C
	decf	DIGITAL,f			; decrease if required
	btfss	DIGITAL,7			; if set then >
	goto	FAST_FLOAT_INC
; slow rate
SLOW2
	incf		CHARGE_CONT,w
	subwf	CHARGE_RATE,w	; stop at charge rate max
	btfss	STATUS,C
	goto	SET_CHARGE		; set value to charge rate
	incf		CHARGE_CONT,f
	goto	STORE_SWITCH
; fast rate
FAST_FLOAT_INC
	movlw	D'3'					; increase by 3
	addwf	CHARGE_CONT,w
	subwf	CHARGE_RATE,w	; stop at charge rate max
	btfss	STATUS,C
	goto	SLOW2				; set value to charge rate
	movlw	D'3'					; increase is not over value so increase charge control
	addwf	CHARGE_CONT,f
	goto	STORE_SWITCH

SET_CHARGE
	movf	CHARGE_RATE,w	; transfer charge rate to control if over in value
	movwf	CHARGE_CONT
	goto	STORE_SWITCH
	
BURST ; burst pulses of current till voltage >low battery voltage
	bsf		CHARGE_FLAG,0	; charge flag set so no charge set in interrupt
	btfsc	ONCE,0				; if clear can show Charge LED
	bcf		PORTB,0			; LEDs off
	bcf		PORTB,1
	bcf		PORTB,2
				
	bcf		PORTB,3			; no drive

	movlw	D'19'
	call		DELAY_1			; delay	
	bcf		INTCON,GIE			; no interrupt
		
	bsf		PORTB,3			; drive on

	btfss	ONCE,0				; if set can show LEDs
	goto	DEL_BURST

	bsf		PORTB,0			; LEDs on
	bsf		PORTB,1
	bsf		PORTB,2
DEL_BURST
	bsf		ONCE,0				; set to show LEDs next time
	movlw	D'4'
	call		DELAY_2			; delay based on charge rate	
	bcf		PORTB,0			; LED off
			
	bcf		PORTB,3			; no drive

	bsf		INTCON,GIE			; interrupt allowed

; if Store switch closed set cutoff, trickle and compensation values in EEPROM 
STORE_SWITCH

; check if charge control over charge rate if so set at charge rate value
	movf	CHARGE_CONT,w
	subwf	CHARGE_RATE,w	; stop at charge rate max
	btfsc	STATUS,C
	goto	STO_CLOSED_CK
	movf	CHARGE_RATE,w	; transfer charge rate to control if over in value
	movwf	CHARGE_CONT

STO_CLOSED_CK
	btfsc	PORTB,5			; store switch if closed
	goto	CYCLE			; store switch not closed
; store switch closed

; only store when JP1 is in adjustable position.  If default position bypass
	btfsc	PORTB,4		; if high goto cycle
	goto	CYCLE			; bypass storing when S1 pressed

; stop drive to Mosfet to quieten A/D inputs	
	bcf		INTCON,GIE		; no interrupt
	
	bcf		PORTB,3		; no drive

	movlw	D'8'
	call		DELAY_1

; Channel 0 A/D value (Cutoff Voltage)
CH_0AD
; set analog input address
	bcf		ADCON0,5
	bcf		ADCON0,4
	bcf		ADCON0,3		; A/D No.0
	call		DEL			; time for inputs to settle
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV6
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV6
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	DIGITAL

; 3V sets 30V = D614 so multiply by 164/100 so 30V results in D1006 to match AN3 batt volts @30V
; A/D value x 164	
	clrf		AARGB0		; ms byte
	movlw	H'0'				; D164
	movwf	AARGB1
	movlw	H'A4'			; 
	movwf	AARGB2
	clrf		BARGB0		; ms
	movf	ADRESH,w		; A/D ms
	movwf	BARGB1
	movf	DIGITAL,w
	movwf	BARGB2
	call		FXM2424U		; multiply
	
; shift to ms bytes
	clrf		AARGB0		; ms cleared
	movf	AARGB3,w
	movwf	AARGB1
	movf	AARGB4,w
	movwf	AARGB2
	movf	AARGB5,w
	movwf	AARGB3	
	clrf		BARGB0
	clrf		BARGB1
	clrf		BARGB2
	movlw	D'100'			; divide by 100
	movwf	BARGB3
; divide by 100
	call	FXD3232U			; divide
; value in AARGB2&3
; write cutout values

; check if SLA, Lead Acid or Lithium at JP3

	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	movwf	DIGITAL
	xorlw	D'02'	
	btfsc	STATUS,Z		; LiFePO4 when w is a 2
 	goto	Li_STO
	movf	DIGITAL,w
	btfsc	STATUS,Z
	goto	SLA_CUTOFF_STO
LA_CUTOFF_STO
	movlw	EEPROM5			; LA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB2,w			; ms byte
	call		EEWRITE			; write to EEPROM

	movlw	EEPROM6			; LA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB3,w			; ls byte
	call		EEWRITE			; write to EEPROM
	goto	CH_6AD


SLA_CUTOFF_STO
	movlw	EEPROM0			; SLA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB2,w			; ms byte
	call		EEWRITE			; write to EEPROM

	movlw	EEPROM1			; SLA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB3,w			; ls byte
	call		EEWRITE			; write to EEPROM
	goto	CH_6AD

Li_STO
	movlw	EEPROMA			; Li address
	call 		EEREAD			; sets EEADR		
	movf	AARGB2,w			; ms byte
	call		EEWRITE			; write to EEPROM

	movlw	EEPROMB			; Li address
	call 		EEREAD			; sets EEADR		
	movf	AARGB3,w			; ls byte
	call		EEWRITE			; write to EEPROM
; end for Lithium settings (no Float and compensation)
	goto	Li_FLASH 


; Channel 0 A/D value (float Voltage)
CH_6AD
; set analog input address
	bsf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3		; A/D No.6
	call		DEL			; time for inputs to settle
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV0
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV0
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	DIGITAL

; 3V sets 30V = D614 so multiply by 164/100 so 30V results in D1006 to match AN3 batt volts @30V
; A/D value x 164	
	clrf		AARGB0		; ms byte
	movlw	H'0'				; D164
	movwf	AARGB1
	movlw	H'A4'	
	movwf	AARGB2
	clrf		BARGB0		; ms
	movf	ADRESH,w		; A/D ms
	movwf	BARGB1
	movf	DIGITAL,w
	movwf	BARGB2
	call		FXM2424U		; multiply
	
; shift to ms bytes
	clrf		AARGB0		; ms cleared
	movf	AARGB3,w
	movwf	AARGB1
	movf	AARGB4,w
	movwf	AARGB2
	movf	AARGB5,w
	movwf	AARGB3	
	clrf		BARGB0
	clrf		BARGB1
	clrf		BARGB2
	movlw	D'100'			; divide by 100
	movwf	BARGB3
; divide by 100
	call		FXD3232U		; divide
; value in AARGB2,3


;  read JP3 for SLA or Lead Acid
	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	movwf	DIGITAL
	movf	DIGITAL,w
	btfsc	STATUS,Z			; if 0 then SLA
 	goto	SLA_FLOAT_STO
LA_FLOAT_STO
	movlw	EEPROM7			; LA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB2,w			; ms byte
	call		EEWRITE			; write to EEPROM

	movlw	EEPROM8			; LA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB3,w			; ls byte
	call		EEWRITE			; write to EEPROM
	goto	CH_5AD

SLA_FLOAT_STO
	movlw	EEPROM2			; SLA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB2,w			; ms byte
	call		EEWRITE			; write to EEPROM

	movlw	EEPROM3			; SLA address
	call 		EEREAD			; sets EEADR		
	movf	AARGB3,w			; ls byte
	call		EEWRITE			; write to EEPROM

; Channel 5 A/D value (Compensation)
CH_5AD
; set analog input address
	bsf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; A/D No.5
	call		DEL			; time for inputs to settle
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	DIGITAL
; change from 10-bit to 8-bit
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right


;  read JP3 for SLA or Lead Acid
	call		JUMPER3		; test JP3 setting
; returns 'w' with 00 for SLA, 01 for Lead Acid and 02 for LiFePO4
	xorlw	D'00'
	btfsc	STATUS,Z		; if 0 then SLA
	goto	SLA_COMP

; write compensation value

	movlw	EEPROM9		; L/A address
	goto	COMP1
SLA_COMP
	movlw	EEPROM4		; SLA address
COMP1
	call 		EEREAD		; sets EEADR		
	movf	DIGITAL,w		; 8-bit byte
	call		EEWRITE		; write to EEPROM

; add switch debounce delay and
; flash LEDs 2, 3, 4 and 5 (Thermistor, Charge, Absorption and Float)
 
	bcf		INTCON,GIE		; no interrupt
	bcf		PORTA,4		; LEDs off Thermistor
	bcf		PORTB,0		; Charge
	bcf		PORTB,1		; Absorption
	bcf		PORTB,2		; Float
	movlw	D'10'
	call		DELAY_1
	bsf		PORTA,4		; LEDs on
	bsf		PORTB,0
	bcf		PORTB,1
	bsf		PORTB,2
	movlw	D'10'
	call	DELAY_1
	bcf		PORTA,4		; LEDs off
	bcf		PORTB,0
	bcf		PORTB,1
	bcf		PORTB,2
	movlw	D'10'
	call	DELAY_1
	bsf		PORTA,4		; LEDs on
	bsf		PORTB,0
	bcf		PORTB,1
	bsf		PORTB,2
	movlw	D'10'
	call	DELAY_1
	bcf		PORTA,4		; LEDs off
	bcf		PORTB,0
	bcf		PORTB,1
	bcf		PORTB,2
	bsf		INTCON,GIE		; allow interrupts
	goto	CYCLE

Li_FLASH
; No Flashing of thermistor and float LED for Lithium (RB2)
 
	bcf		INTCON,GIE		; no interrupt
; LEDs off
	bcf		PORTA,4
	bcf		PORTB,0
	bcf		PORTB,1
	bcf		PORTB,2
	movlw	D'10'
	call		DELAY_1
; LEDs on
	bsf		PORTB,0
	bsf		PORTB,1
	movlw	D'10'
	call		DELAY_1
; LEDs off
	bcf		PORTB,0
	bcf		PORTB,1
	movlw	D'10'
	call		DELAY_1
; LEDs on
	bsf		PORTB,0
	bsf		PORTB,1
	movlw	D'10'
	call		DELAY_1
Li_END
; LEDs off
	bcf		PORTB,0
	bcf		PORTB,1
	bsf		INTCON,GIE		; allow interrupts
	goto	CYCLE
 ; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	
INTERRUPT
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; bank select
	bcf 		STATUS,RP1	; select memory bank 0 

	btfss	PIR1,TMR1IF		; timer 1 interrupt flag
	goto	CHECK_END	; no timer interrupt so exit
	bcf		PIR1,TMR1IF		; clear flag

; preload timer 1 so it overflows in 40,000 counts for 20ms
; use 65,536-40,000 = 25,536 (H63C0) preload 
; add 16 to compensate for interrupt, the above code and when the timer is reloaded

	bcf		T1CON,0		; stop timer
	movlw	H'D0'			; ls byte plus 16
	movwf	TMR1L
	movlw	H'63'			; ms byte
	movwf	TMR1H
	bsf		T1CON,0		; restart timer

; flasher rate
	incf		FLASHER,f		; flasher
	movf	FLASHER,w
	sublw	D'50'	
	btfss	STATUS,C
	clrf 		FLASHER		; count to 50 for 1 second

; when cleared increment a/d counter
	movf	FLASHER,w
	btfsc	STATUS,Z		; when zero increment counter
	incf		AD_COUNT,f
	movf	AD_COUNT,w
	sublw	D'1'				; clear every 2 seconds
	btfsc	STATUS,C
	goto	INC_SEC
	clrf		AD_COUNT
	bsf		END_FLG,1		; set every 2-seconds

INC_SEC
; when cleared increment seconds counter
	movf	FLASHER,w
	btfss	STATUS,Z		; when zero increment seconds
	goto	THERM_FLSH

;*****  test to check timeout for charger disconnected but battery connected. Normally remarked out. Requires HOUR3 to be set at 20
;	goto	HR
; end test

	incf		SECONDS,f
	movf	SECONDS,w
	sublw	D'60'			; clear every 60 seconds
	btfsc	STATUS,C
	goto	THERM_FLSH
	clrf		SECONDS

; when cleared increment minutes counter
	incf		MINUTES,f
	movf	MINUTES,w
	sublw	D'60'			; clear every 60 minutes
	btfsc	STATUS,C
	goto	THERM_FLSH
	clrf		MINUTES	
	
; when cleared decrement hour counter 
	movf	HOUR,w			; if zero no decrement
	btfss	STATUS,Z
	decf	HOUR,f

; and timer to prevent battery discharge
HR
	movf	HOUR2,w			; if zero no decrement
	btfss	STATUS,Z
	decf	HOUR2,f

THERM_FLSH
; check thermistor flash or on or off
	movf	THERMISTOR,w
	btfsc	STATUS,Z		; if clear set to off
	goto	THERM_LED_OFF
	btfss	THERMISTOR,1	; if set then flash
	goto	THERM_LED_ON
	
; flash
	btfss	FLASHER,4		; bit set on
	goto	THERM_LED_OFF
THERM_LED_ON
	bsf		PORTA,4		; thermistor on
	goto	DRIVE
THERM_LED_OFF
	bcf		PORTA,4
	
DRIVE
	btfsc	CHARGE_FLAG,0	; when set clear charge
	goto	CHARGE_OFF
; charge
	movf	CHARGE_STATE,w	; 0 charge, 1 absorption and 2 float
	btfsc	STATUS,Z
	goto	CHARGE_FULL_RUN

; absorption and float charge control counter
	incf		CHARGE_PULSE,f
	movf	CHARGE_PULSE,w	; counter to adjust rate
	sublw	D'99'
	btfsc	STATUS,C			; if 100 reset
	goto	COMP_RATE
	clrf		CHARGE_PULSE
	movf	CHARGE_CONT,w
	movwf	CHARGE_CONT1
	bcf		END_FLG,3

COMP_RATE
; compare charge rate setting with counter to drive at % set
	movf	CHARGE_CONT1,w	; charge control
	subwf	CHARGE_PULSE,w
	btfsc	STATUS,C
	goto	NO_CHRG1
; charge on

; check if lithium charge has ended
	btfsc	LITHIUM,0			; if set end of charge
	goto	NO_CHRG			; no charge
		
	bsf		PORTB,3			; charge on

	btfsc	CHRG_SHOW,0		; shows charge LED
	bsf		PORTB,0			; shows charge LED
	goto	CHECK_END	

CHARGE_FULL_RUN
	incf		CHARGE_PULSE,f
	movf	CHARGE_PULSE,w	; counter to adjust rate
	sublw	D'99'
	btfsc	STATUS,C			; if 100 reset
	goto	COMP_RATE1
	clrf		CHARGE_PULSE
	bcf		END_FLG,3	

COMP_RATE1
; compare charge rate setting with counter to drive at % set
	movf	CHARGE_RATE,w
	subwf	CHARGE_PULSE,w
	btfsc	STATUS,C
	goto	NO_CHRG1
; charge on
		
; check if lithium charge has ended
	btfsc	LITHIUM,0			; if set end of charge
	goto	NO_CHRG			; no charge

	bsf		PORTB,3			; charge on

	bsf		PORTB,0			; charge LED on
	goto	CHECK_END	
NO_CHRG1
	btfss	END_FLG,3		; when clear can set 0
	bsf		END_FLG,0		; set flag when off to read battery at end of charge pulses
	bsf		END_FLG,3		; set to stop further 0 settings
	bcf		PORTB,0		; charge LED off
	goto	NO_CHRG	
CHARGE_OFF
; LEDs off
	bsf		END_FLG,0		; set flag so A/D can run
	bcf		PORTB,0
	bcf		PORTB,1
	bcf		PORTB,2
NO_CHRG
		
	bcf		PORTB,3		; no charge

CHECK_END
; end of interrupt reclaim w and status 
	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt

; **************************************************************
; Subroutines

JUMPER3; subroutine to test JP3 setting
; set RA7 as a low output
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7			; RA7 an output
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,7		; low
	nop
	nop
; set RA7 as an input 
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7			; RA7 an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
	nop
	btfsc	PORTA,7
	retlw	D'00'			; if high then pulled high at JP3 for SLA selection (0 in w)

; set RA7 as a high output
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7			; RA7 an output
	bcf		STATUS,RP0	; select memory bank 0
	bsf		PORTA,7		; high
	nop
	nop
; set RA7 as an input 
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7			; RA7 an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
	nop
	btfss	PORTA,7		; if low then pulled low at JP3 for Lead Acid
	retlw	D'01'			; LEAD_ACID (1 in w)
	retlw	D'02'			; LiFePO4 (if not 0 or 1 then a 2)

; subroutine to read EEPROM memory

EEREAD
	bcf		INTCON,GIE	; disable interrupts	
	bcf 		STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 		STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		INTCON,GIE	; enable interrupts
	return

; subroutine to write to EEPROM
EEWRITE
EWRITE
	bcf		INTCON,GIE	; disable interrupts
	bsf	    	STATUS,RP1	; select bank 
	bcf 		STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 		STATUS,RP1	; select memory bank 0 
	bsf		INTCON,GIE	; enable interrupts
	return				; value written 

; delays

; DELAY for A/D acquisition
DEL
	movlw	H'08'
	movwf	DELCNT
DEL1
	decfsz	DELCNT,f
	goto	DEL1
	return

; delay general purpose
DELAY
	movlw	D'10'		; number of delay cycles
DELAY_1	
	movwf	DELCNT

DELAY_M
	movlw	D'255'		; set delay period 
	movwf	VALUE_1		; VALUE_1 = w
LP_1
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1
	decfsz	DELCNT,f
	goto	DELAY_M
	return	

; Delay based on charge rate setting
DELAY_2	
	movwf	DELCNT
DELAY_L
	incf	CHARGE_RATE,w	; set delay period based on charge rate setting (increment to avoid 0)
	movwf	VALUE_1		; VALUE_1 = w
LP_3
	movlw	D'240'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_4
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_4
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_3
	decfsz	DELCNT,f
	goto	DELAY_L
	return	

; *********************************
; 24x24 Bit Unsigned Fixed Point Multiply 24x24 -> 48
; Input: 24 bit unsigned fixed point multiplicand in AARGB0,1,2
; 24 bit unsigned fixed point multiplier in BARGB0,1,2
; Use: CALL FXM2424U
; Output: 48 bit unsigned fixed point product in AARGB0
; Result: AARG <-- AARG x BARG
; Max Timing: 9+501+2 = 512 clks
; Min Timing: 9+150 = 159 clks

FXM2424U
	CLRF 	AARGB3 ; clear partial product
	CLRF 	AARGB4
	CLRF 	AARGB5
	MOVF 	AARGB0,W
	MOVWF 	TEMPB0
	MOVF 	AARGB1,W
	MOVWF 	TEMPB1
	MOVF 	AARGB2,W
	MOVWF 	TEMPB2

	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
LOOPUM2424A
	RRF 	BARGB2,F
	BTFSC 	STATUS,C
	GOTO 	ALUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO	LOOPUM2424A
	MOVWF 	LOOPCOUNT
LOOPUM2424B
	RRF 	BARGB1,F
	BTFSC 	STATUS,C
	GOTO	BLUM2424NAP
	DECFSZ	LOOPCOUNT,F
	GOTO	LOOPUM2424B
	MOVWF	LOOPCOUNT
LOOPUM2424C
	RRF		BARGB0,F
	BTFSC 	STATUS,C
	GOTO 	CLUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPUM2424C
	CLRF 	AARGB0
	CLRF 	AARGB1
	CLRF 	AARGB2
	RETLW 	0x00
CLUM2424NAP
	BCF 	STATUS,C
	GOTO 	CLUM2424NA
BLUM2424NAP
	BCF 	STATUS,C
	GOTO 	BLUM2424NA
ALUM2424NAP
	BCF 	STATUS,C
	GOTO 	ALUM2424NA
ALOOPUM2424
	RRF 	BARGB2,F
	BTFSS 	STATUS,C
	GOTO 	ALUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF	AARGB0,F
ALUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	ALOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
BLOOPUM2424
	RRF 	BARGB1,F
	BTFSS 	STATUS,C
	GOTO 	BLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
BLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	BLOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
CLOOPUM2424
	RRF 	BARGB0,F
	BTFSS 	STATUS,C
	GOTO 	CLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
CLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	RRF 	AARGB5,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	CLOOPUM2424
	return

; ********************************
; 32/32 Bit Unsigned Fixed Point Divide 32/32 -> 32.32
; Input: 32 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2,AARGB3
; 32 bit unsigned fixed point divisor in BARGB0, BARGB1, BARGB2, BARGB3
; Use: CALL FXD3232U
; Output: 32 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2,AARGB3
; 32 bit unsigned fixed point remainder in REMB0, REMB1, REMB2, REMB3
; Result: AARG, REM <-- AARG / BARG
; Max Timing: 4+1025+2 = 1031 clks
; Max Timing: 4+981+2 = 987 clks
; PM: 4+359+1 = 364 DM: 13
FXD3232U
	CLRF 	REMB0
	CLRF	REMB1
	CLRF 	REMB2
	CLRF 	REMB3
	call	UDIV3232L
	return

UDIV3232L 
; Max Timing: 24+6*32+31+31+6*32+31+31+6*32+31+31+6*32+31+16 = 1025 clks
; Min Timing: 24+6*31+30+30+6*31+30+30+6*31+30+30+6*31+30+3 = 981 clks
; PM: 359 DM: 13
	CLRF 	TEMP
	RLF 	AARGB0,W
	RLF 	REMB3,F
	MOVF 	BARGB3,W
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	RLF 	AARGB0,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232A 
	RLF 	AARGB0,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB0,0
	GOTO 	UADD22LA
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LA

UADD22LA 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LA 
	RLF		AARGB0,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232A
	RLF 	AARGB1,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB0,0
	GOTO 	UADD22L8
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L8

UADD22L8 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22L8 
	RLF 	AARGB1,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232B 
	RLF 	AARGB1,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB1,0
	GOTO 	UADD22LB
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LB

UADD22LB 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LB 
	RLF 	AARGB1,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232B
	RLF 	AARGB2,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS	AARGB1,0
	GOTO 	UADD22L16
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L16

UADD22L16 	
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF	TEMP,F

UOK22L16
	RLF		AARGB2,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232C 
	RLF 	AARGB2,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB2,0
	GOTO 	UADD22LC
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LC

UADD22LC
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LC 
	RLF 	AARGB2,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232C
	RLF 	AARGB3,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB2,0
	GOTO 	UADD22L24
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L24

UADD22L24 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22L24 
	RLF 	AARGB3,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232D 
    RLF  	AARGB3,W
    RLF    	REMB3,F
    RLF    	REMB2,F
    RLF    	REMB1,F
    RLF    	REMB0,F
    RLF    	TEMP,F
    MOVF   	BARGB3,W
 	BTFSS  	AARGB3,0
   	GOTO   	UADD22LD

    SUBWF  	REMB3,F
  	MOVF   	BARGB2,W
    BTFSS   STATUS,C
    INCFSZ  BARGB2,W
    SUBWF   REMB2,F
    MOVF    BARGB1,W
    BTFSS   STATUS,C
    INCFSZ  BARGB1,W
    SUBWF   REMB1,F
    MOVF    BARGB0,W
    BTFSS   STATUS,C
    INCFSZ  BARGB0,W
    SUBWF   REMB0,F
    CLRW
    BTFSS   STATUS,C
    MOVLW   H'1'
    SUBWF   TEMP,F
    GOTO    UOK22LD

UADD22LD      
	ADDWF   REMB3,F
    MOVF    BARGB2,W
    BTFSC   STATUS,C
    INCFSZ  BARGB2,W
    ADDWF   REMB2,F
    MOVF    BARGB1,W
    BTFSC   STATUS,C
    INCFSZ  BARGB1,W
    ADDWF   REMB1,F
    MOVF    BARGB0,W
    BTFSC   STATUS,C
    INCFSZ  BARGB0,W
    ADDWF   REMB0,F
    CLRW
    BTFSC   STATUS,C
    MOVLW   H'1'
    ADDWF   TEMP,F
        
UOK22LD
	RLF     AARGB3,F

   	DECFSZ  LOOPCOUNT, F
    GOTO    LOOPU3232D

    BTFSC   AARGB3,0
    GOTO    UOK22L
    MOVF    BARGB3,W
	ADDWF   REMB3,F
    MOVF    BARGB2,W
    BTFSC   STATUS,C
    INCFSZ  BARGB2,W
    ADDWF   REMB2,F
    MOVF    BARGB1,W
    BTFSC   STATUS,C
    INCFSZ  BARGB1,W
    ADDWF   REMB1,F
    MOVF    BARGB0,W
    BTFSC   STATUS,C
    INCFSZ  BARGB0,W
    ADDWF   REMB0,F

UOK22L

	RETURN

; ******************	
; 8 x 8 multiply

EIGHTEIGHT   
		CLRF    AARGB1          ; clear partial product
UMUL0808L        
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   H'00'

LUM0808NAP
                BCF     STATUS,C
                GOTO    LUM0808NA

LOOPUM0808
                RRF     BARGB0, F
                BTFSC   STATUS,C
                ADDWF   AARGB0, F
LUM0808NA       RRF    	AARGB0, F
                RRF    	AARGB1, F
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808

                return  


 end
